package nemosofts.voxradio.adapter.home;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.material.EqualizerView;
import androidx.nemosofts.material.ImageHelperView;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.List;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.item.ItemRadio;

public class AdapterHomeRecent extends RecyclerView.Adapter<AdapterHomeRecent.MyViewHolder> {

    Context context;
    List<ItemRadio> arrayList;

    public static class MyViewHolder extends RecyclerView.ViewHolder {

        private final TextView title;
        private final ImageView play;
        private final EqualizerView equalizer;
        private final ImageHelperView poster;

        MyViewHolder(View view) {
            super(view);
            title = view.findViewById(R.id.tv_recent_title);
            play = view.findViewById(R.id.iv_play_view);
            equalizer = view.findViewById(R.id.equalizer_recent);
            poster = view.findViewById(R.id.iv_recently);
        }
    }

    public AdapterHomeRecent(Context context, List<ItemRadio> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_recently, parent, false);
        return new MyViewHolder(itemView);
    }

    @OptIn(markerClass = UnstableApi.class)
    @Override
    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {

        holder.title.setText(arrayList.get(position).getRadioTitle());

        Picasso.get()
                .load(arrayList.get(position).getImage())
                .resize(300,300)
                .placeholder(R.drawable.material_design_default)
                .error(R.drawable.material_design_default)
                .into(holder.poster);
        
        if (PlayerService.getIsPlaying()
                && Callback.getArrayListPlay().get(Callback.getPlayPos()).getId().equals(arrayList.get(position).getId())
                && Boolean.TRUE.equals(Callback.getIsRadio())) {
            holder.equalizer.setVisibility(View.VISIBLE);
            holder.equalizer.animateBars();
            holder.play.setImageResource(R.drawable.ic_pause);
        } else {
            holder.equalizer.setVisibility(View.GONE);
            holder.equalizer.stopBars();
            holder.play.setImageResource(R.drawable.ic_play);
        }
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

}